
unit WebForm9;

interface

uses
  SysUtils, System.Web.Security, System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
  TWebForm9 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
		procedure UpdateBtn_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure PrepareDevelperChangeDetails;
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
		TopHolder: System.Web.UI.WebControls.PlaceHolder;
		CategoriesHolder: System.Web.UI.WebControls.PlaceHolder;
		topicHeading: System.Web.UI.WebControls.Label;
		topicDescription: System.Web.UI.WebControls.Label;
		MyError: System.Web.UI.WebControls.Label;
		RequiredFieldValidator1: System.Web.UI.WebControls.RequiredFieldValidator;
		Name: System.Web.UI.WebControls.TextBox;
		Address: System.Web.UI.WebControls.TextBox;
		Tel: System.Web.UI.WebControls.TextBox;
		Fax: System.Web.UI.WebControls.TextBox;
		Contact: System.Web.UI.WebControls.TextBox;
		RequiredFieldValidator9: System.Web.UI.WebControls.RequiredFieldValidator;
		WebSite: System.Web.UI.WebControls.TextBox;
		RegularExpressionValidator1: System.Web.UI.WebControls.RegularExpressionValidator;
		RequiredFieldValidator2: System.Web.UI.WebControls.RequiredFieldValidator;
		Email: System.Web.UI.WebControls.TextBox;
		PasswordRequiredValidator: System.Web.UI.WebControls.RequiredFieldValidator;
		Password: System.Web.UI.WebControls.TextBox;
		PasswordConfirmRequiredValidator: System.Web.UI.WebControls.RequiredFieldValidator;
		CompareValidator1: System.Web.UI.WebControls.CompareValidator;
		ConfirmPassword: System.Web.UI.WebControls.TextBox;
		UpdateBtn: System.Web.UI.WebControls.Button;
    procedure OnInit(e: EventArgs); override;
  end;

implementation


uses catgrid, developersDB, top, apptypes;

var _top : CSTop;
    _AppTypes : csAppTypes;

procedure TWebForm9.PrepareDevelperChangeDetails;
var
  context : HttpContext;
  DeveloperID: integer;
  dev : TdevelopersDB;
  devdetails : DeveloperDetails;
begin
  context := HttpContext.Current;
  if context.User.Identity.Name <> '' then
  begin
    DeveloperID := StrToInt(context.User.Identity.Name);
    if DeveloperID = 0 then Response.Redirect('webform4.aspx');

    topicDescription.Text:='editing your profile';

    dev := TdevelopersDB.Create;
    devdetails := DeveloperDetails.Create;

    devdetails:= dev.GetDeveloperDetails(DeveloperID);

    Name.Text:=devdetails.Name;
    Address.Text:=devdetails.Address;
    Tel.Text:=devdetails.Tel;
    Fax.Text:=devdetails.Fax;
    Contact.Text:=devdetails.Contact;
    WebSite.Text:=devdetails.WebSite;
    Email.Text:=devdetails.Email;
    //PasswordRequiredValidator.InitialValue:=devdetails.password;
    //PasswordConfirmRequiredValidator.InitialValue:=devdetails.password;
    password.Text:=devdetails.password;
    confirmpassword.Text:=devdetails.password;
  end
  else
  begin
    //u pravilu ovo ne moze biti osim ako nije direkto upisan query string u URL
    // naime ovdje se moze doci sa editproducts.aspx - a tamo samo ako je logiran
    Response.Redirect('webform4.aspx');
  end;
end;

procedure TWebForm9.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // Put user code to initialize the page here
  EnableViewState:=False;

			topicHeading.Text:='Login to "Octane examples"';
			topicDescription.Text:='manage your account...';
			if NOT ispostback then PrepareDevelperChangeDetails;
end;

procedure TWebForm9.OnInit(e: EventArgs);
begin
  //
  // CODEGEN: This call is required by the ASP.NET Web Form Designer.
  //
  InitializeComponent;
  inherited OnInit(e);

      _AppTypes := csAppTypes.create;
      CategoriesHolder.Controls.Add(_AppTypes);
      _AppTypes.Free;

      _top := CSTop.create;
      TopHolder.Controls.Add(_top);
      _top.Free;
end;

procedure TWebForm9.UpdateBtn_Click(sender: System.Object; e: System.EventArgs);
var
  DeveloperID:integer;
  Developer : TdevelopersDB;
  kuky: HttpCookie;
  context : HttpContext;
begin
  Page.Validate;
  if not Page.IsValid = true Then Exit;

  //Add New Developer to database
  Developer := TdevelopersDB.create;

  if true then
  begin
    context := HttpContext.Current;
    DeveloperID := StrToInt(context.User.Identity.Name);
    topicDescription.Text:='UpdateDeveloper' + inttostr(developerid);
    if Developer.UpdateDeveloper(DeveloperID,
                                Server.HtmlEncode(Name.Text),
                                Server.HtmlEncode(Address.Text),
                                Server.HtmlEncode(WebSite.Text),
                                Email.Text,
                                Server.HtmlEncode(Tel.Text),
                                Server.HtmlEncode(Fax.Text),
                                Server.HtmlEncode(Contact.Text),
                                Password.Text) = true then
    begin
      FormsAuthentication.SetAuthCookie(IntToStr(DeveloperID), false);
      kuky:=HttpCookie.create('owe_name');
      kuky.Value:=Server.HtmlEncode(Name.Text);
      Response.Cookies.Add(kuky);
//					topicDescription.Text:=topicDescription.Text + Server.HtmlEncode(Contact.Text);
      Response.Redirect('webform5.aspx');
    end
    else
     MyError.Text := 'Error.';
  end;
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm9.InitializeComponent;
begin
	Include(Self.UpdateBtn.Click, Self.UpdateBtn_Click);
	Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


end.

